/////////////////////////////////
// CISE4
// Leds_1.axe: Projecte de configuraci.
// v1.0 - (c)2001 DEE-UPC
// Timers.c: Programa de config dels temporitzadors
/////////////////////////////////

#include <embedded.h>

#include "typedefs.h"
#include "int.h"
#include "register.h"
#include "timers.h"	//funcions de control dels temporitzadors

// Variables globals
int iTick;		//control del pas per la RSI de la base de temps

// Inicialitzaci dels temporitzadors
// (actualment, noms la base de temps)
void IniTimers(void)
{
BYTE far *pbyReg;	//punter a un registre

   //substituir el vector d'interrupci de la base de temps
   disable();		//no permetre cap INT
   setvect(INTBASETEMPS, RSIBaseTemps);
   enable();

   //crear el punter al registre de control del processador PRC
	pbyReg = (BYTE far *)MK_FP(RSEG, PRC);

   //modificar el registre PRC per a una int cada 2.05 ms
   *pbyReg = 0x04;	//RAM interna deshabilitada
   						//Fclk de 4 MHz

   //apuntar al registre TBIC
	pbyReg = (BYTE far *)MK_FP(RSEG, TBIC);
   *pbyReg &= 0xBF;	//activar interrupcions BT

}

// Retorna desprs d'un retard de 'iTemps'
// ticks de la base de temps.
// (1 tick aprox xx.x ms)
void Retard(int iTemps)
{
   //modificar el valor de la variable de control
   disable();
   iTick = iTemps;
   enable();

   //esperar 'iTemps'
   while(iTick != 0)
   	enable();
}

// Servei d'interrupci de la base de temps
void interrupt RSIBaseTemps(void)
{
   enable();	//permetre altres INT.

   if(iTick > 0)
      --iTick;	//marcar la passada
   FINT;
}

